<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';

requireLogin();

$pageTitle = 'پروفایل کاربری';
$success = '';
$error = '';

// Handle password change
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['change_password'])) {
    $currentPassword = $_POST['current_password'] ?? '';
    $newPassword = $_POST['new_password'] ?? '';
    $confirmPassword = $_POST['confirm_password'] ?? '';
    
    $user = getUserByMobile($_SESSION['mobile']);
    
    if (empty($currentPassword) || empty($newPassword) || empty($confirmPassword)) {
        $error = 'لطفاً تمام فیلدها را پر کنید.';
    } elseif (!password_verify($currentPassword, $user['password'])) {
        $error = 'رمز عبور فعلی اشتباه است.';
    } elseif (strlen($newPassword) < 6) {
        $error = 'رمز عبور جدید باید حداقل 6 کاراکتر باشد.';
    } elseif ($newPassword !== $confirmPassword) {
        $error = 'رمز عبور جدید و تکرار آن یکسان نیستند.';
    } else {
        $conn = getDBConnection();
        $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
        $stmt->bind_param("si", $hashedPassword, $_SESSION['user_id']);
        
        if ($stmt->execute()) {
            $success = 'رمز عبور با موفقیت تغییر یافت.';
        } else {
            $error = 'خطا در تغییر رمز عبور.';
        }
        
        $stmt->close();
        $conn->close();
    }
}

include __DIR__ . '/../includes/header.php';
?>

<div class="container">
    <div class="page-header">
        <h1>
            <i class="fas fa-user"></i>
            پروفایل کاربری
        </h1>
    </div>

    <div class="profile-container">
        <div class="profile-card">
            <h2>اطلاعات کاربری</h2>
            
            <div class="profile-info">
                <div class="info-row">
                    <label>
                        <i class="fas fa-mobile-alt"></i>
                        شماره موبایل:
                    </label>
                    <span><?php echo htmlspecialchars($_SESSION['mobile']); ?></span>
                </div>
                
                <div class="info-row">
                    <label>
                        <i class="fas fa-envelope"></i>
                        ایمیل:
                    </label>
                    <span><?php echo htmlspecialchars($_SESSION['email']); ?></span>
                </div>
            </div>
        </div>

        <div class="profile-card">
            <h2>تغییر رمز عبور</h2>

            <?php if ($error): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i>
                <?php echo $error; ?>
            </div>
            <?php endif; ?>

            <?php if ($success): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?php echo $success; ?>
            </div>
            <?php endif; ?>

            <form method="POST" class="profile-form">
                <div class="form-group">
                    <label>رمز عبور فعلی</label>
                    <input type="password" name="current_password" required>
                </div>

                <div class="form-group">
                    <label>رمز عبور جدید</label>
                    <input type="password" name="new_password" required>
                </div>

                <div class="form-group">
                    <label>تکرار رمز عبور جدید</label>
                    <input type="password" name="confirm_password" required>
                </div>

                <button type="submit" name="change_password" class="btn btn-primary">
                    <i class="fas fa-save"></i>
                    تغییر رمز عبور
                </button>
            </form>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>